package ch.frankel.blog.hibernate;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

import org.apache.commons.io.FileUtils;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

/**
 * Sets up the test's datas.
 * 
 * @author Nicolas Frnkel
 * @since 20 juin 2009
 */
public abstract class AbstractTest {

    /** Hibernate's session factory. */
    protected SessionFactory factory;

    /**
     * Start with a fresh DB.
     */
    @BeforeClass
    protected void setUpFactory() {

        factory = new AnnotationConfiguration().configure().buildSessionFactory();
    }

    /**
     * Sets up the factory used for the test.
     * 
     * @throws Exception
     * 
     */
    @BeforeMethod
    protected void setUpDatas() throws Exception {

        Connection connection = DriverManager.getConnection("jdbc:derby:target/myDb");

        try {

            URL url = getClass().getClassLoader().getResource("script.sql");

            File file = new File(url.toURI());

            String sql = FileUtils.readFileToString(file);

            Statement dmlStmt = connection.createStatement();

            for (String insert : sql.split(";")) {

                dmlStmt.addBatch(insert);
            }

            dmlStmt.executeBatch();

        } finally {

            connection.close();
        }
    }
}
